import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.productCategoryId) {
    newObjValue = {...newObjValue, 
      M_Product_Category_ID: {
        id: body.productCategoryId,
        tableName: 'M_Product_Category'
      }
    }
  }

  if(body.discountSchemaId) {
    const res: any = await fetchHelper(event, 'models/m_discountschemabreak', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      seqNo: body.seqNo,
      breakValue: body.breakValue,
      breakDiscount: body.breakDiscount,
      isBPartnerFlatDiscount: body.isBPartnerFlatDiscount,
      fixedPrice: body.fixedPrice,
      M_DiscountSchema_ID: {
        id: body.discountSchemaId,
        tableName: 'M_DiscountSchema'
      },
      ...newObjValue,
      tableName: 'm_discountschemabreak'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})